/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.measure.quantity.Time;
import maschine.Maschine;
import mensch.Mitarbeiter;
import simulation.PruefErgebnis;
import simulation.SimulationsErgebnisBuilder;
import simulation.SimulationsHelper.Auslastung;
import simulation.SimulationsHelper.SimulationsKonstanten;
import tec.uom.se.ComparableQuantity;
import util.Fraction;

public final class SimulationsErgebnis
implements Comparable<SimulationsErgebnis> {
    private final PruefErgebnis pruefErgebnis;
    private final Map<ProduktionsAuftrag, ComparableQuantity<Time>> verbrauchteZeitProProduktionsAuftrag;
    private final Map<Maschine, Auslastung> auslastungProMaschine;
    private final Map<Mitarbeiter, Auslastung> auslastungProMitarbeiter;
    private final Collection<Dokumentenklasse> nichtEingehalteneSlas;

    SimulationsErgebnis(PruefErgebnis pruefErgebnis, Map<ProduktionsAuftrag, ComparableQuantity<Time>> verbrauchteZeitProProduktionsAuftrag, Map<Maschine, Auslastung> auslastungProMaschine, Map<Mitarbeiter, Auslastung> auslastungProMitarbeiter, Collection<Dokumentenklasse> nichtEingehalteneSlas) {
        this.pruefErgebnis = pruefErgebnis;
        this.verbrauchteZeitProProduktionsAuftrag = verbrauchteZeitProProduktionsAuftrag;
        this.auslastungProMaschine = auslastungProMaschine;
        this.auslastungProMitarbeiter = auslastungProMitarbeiter;
        this.nichtEingehalteneSlas = nichtEingehalteneSlas;
    }

    static SimulationsErgebnisBuilder builder() {
        return SimulationsErgebnisBuilder.create();
    }

    public PruefErgebnis getPruefErgebnis() {
        return this.pruefErgebnis;
    }

    public Map<ProduktionsAuftrag, ComparableQuantity<Time>> getVerbrauchteZeitProProduktionsAuftrag() {
        return Collections.unmodifiableMap(this.verbrauchteZeitProProduktionsAuftrag);
    }

    public Map<Maschine, Auslastung> getAuslastungProMaschine() {
        return Collections.unmodifiableMap(this.auslastungProMaschine);
    }

    public Map<Mitarbeiter, Auslastung> getAuslastungProMitarbeiter() {
        return Collections.unmodifiableMap(this.auslastungProMitarbeiter);
    }

    public Collection<Dokumentenklasse> getNichtEingehalteneSlas() {
        return Collections.unmodifiableCollection(this.nichtEingehalteneSlas);
    }

    public Fraction getGesamtAuslastungDerMitarbeiter() {
        return this.getGesamtAuslastung(this.auslastungProMitarbeiter.values());
    }

    public Fraction getGesamtAuslastungDerMaschinen() {
        return this.getGesamtAuslastung(this.auslastungProMaschine.values());
    }

    private Fraction getGesamtAuslastung(Collection<Auslastung> values) {
        Auslastung aggregierteAuslastung = values.stream().reduce(Auslastung.NEUTRAL_AUSLASTUNG, Auslastung::add);
        return aggregierteAuslastung.asFraction();
    }

    public ComparableQuantity<Time> getGesamteVerbrauchteZeit() {
        return this.verbrauchteZeitProProduktionsAuftrag.values().stream().reduce(SimulationsKonstanten.NEUTRALE_ZEIT, ComparableQuantity::add);
    }

    @Override
    public int compareTo(SimulationsErgebnis o) {
        return this.compareSLA(o);
    }

    private int compareSLA(SimulationsErgebnis o) {
        int compareSLA = Integer.compare(this.nichtEingehalteneSlas.size(), o.getNichtEingehalteneSlas().size()) * -1;
        if (compareSLA == 0) {
            return this.compareMaschinenauslastung(o);
        }
        return compareSLA;
    }

    private int compareMaschinenauslastung(SimulationsErgebnis o) {
        int compareMaschinenauslastung = this.getGesamtAuslastungDerMaschinen().compareTo(o.getGesamtAuslastungDerMaschinen()) * -1;
        if (compareMaschinenauslastung == 0) {
            return this.compareMitarbeiterauslastung(o);
        }
        return compareMaschinenauslastung;
    }

    private int compareMitarbeiterauslastung(SimulationsErgebnis o) {
        int compareMitarbeiterauslastung = this.getGesamtAuslastungDerMitarbeiter().compareTo(o.getGesamtAuslastungDerMitarbeiter()) * -1;
        if (compareMitarbeiterauslastung == 0) {
            return this.compareVerbrauchteZeit(o);
        }
        return compareMitarbeiterauslastung;
    }

    private int compareVerbrauchteZeit(SimulationsErgebnis o) {
        return this.getGesamteVerbrauchteZeit().compareTo(o.getGesamteVerbrauchteZeit()) * -1;
    }

    public void erzeugeKalendereintraege() {
        this.pruefErgebnis.getGepruefteBelegungen().erzeugeKalendereintraege();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulationsErgebnis that = (SimulationsErgebnis)o;
        return Objects.equals(this.pruefErgebnis, that.pruefErgebnis) && Objects.equals(this.verbrauchteZeitProProduktionsAuftrag, that.verbrauchteZeitProProduktionsAuftrag) && Objects.equals(this.auslastungProMaschine, that.auslastungProMaschine) && Objects.equals(this.auslastungProMitarbeiter, that.auslastungProMitarbeiter) && Objects.equals(this.nichtEingehalteneSlas, that.nichtEingehalteneSlas);
    }

    public int hashCode() {
        return Objects.hash(this.pruefErgebnis, this.verbrauchteZeitProProduktionsAuftrag, this.auslastungProMaschine, this.auslastungProMitarbeiter, this.nichtEingehalteneSlas);
    }
}

