/*
 * Decompiled with CFR 0.152.
 */
package auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen;

import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameter;
import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameterVisitor;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariablenVisitor;
import auftraege.factory.ProzessModellFactory;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import maschine.faehigkeit.MaschinenFaehigkeit;

public class ProzessModell
implements DokumentenklassenVariable,
AusschliessenderParameter {
    public static final ProzessModell DRUCKEN_KUVERTIEREN = ProzessModellFactory.INSTANCE.parse("Drucken, Kuvertieren");
    private final Set<MaschinenFaehigkeit> faehigkeiten;

    public ProzessModell() {
        this.faehigkeiten = new HashSet<MaschinenFaehigkeit>();
    }

    public ProzessModell(Set<MaschinenFaehigkeit> faehigkeiten) {
        this.faehigkeiten = faehigkeiten;
    }

    public ProzessModell(MaschinenFaehigkeit ... faehigkeiten) {
        this.faehigkeiten = Stream.of(faehigkeiten).collect(Collectors.toSet());
    }

    @Override
    public <T> T accept(DokumentenklassenVariablenVisitor<T> v) {
        return v.handle(this);
    }

    public Set<MaschinenFaehigkeit> getFaehigkeiten() {
        return this.faehigkeiten;
    }

    public void addFaehigkeit(MaschinenFaehigkeit maschinenFaehigkeit) {
        this.faehigkeiten.add(maschinenFaehigkeit);
    }

    @Override
    public <T> T accept(AusschliessenderParameterVisitor<T> v) {
        return v.handle(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProzessModell)) {
            return false;
        }
        ProzessModell that = (ProzessModell)o;
        return Objects.equals(this.faehigkeiten, that.faehigkeiten);
    }

    public int hashCode() {
        return Objects.hash(this.faehigkeiten);
    }

    public String toString() {
        return "ProzessModell{" + this.faehigkeiten + '}';
    }
}

