/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import persist.Persistierer;

public class ClassObjectMap<T> {
    private final Map<Class<? extends T>, T> map = new HashMap<Class<? extends T>, T>();

    public ClassObjectMap<T> put(T element) {
        this.map.put(element.getClass(), element);
        return this;
    }

    @SafeVarargs
    public final void putAll(T ... elements) {
        Arrays.asList(elements).forEach(this::put);
    }

    public <E> Optional<E> get(Class<E> clazz) {
        return Optional.ofNullable(this.map.get(clazz));
    }

    public ClassObjectMap<T> copy() {
        return (ClassObjectMap)Persistierer.vonXML((String)Persistierer.zuXML((Object)this));
    }

    public <U> Set<U> getBySuperclass(Class<U> clazz) {
        return this.map.keySet().stream().filter(clazz::isAssignableFrom).map(key -> this.map.get(key)).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.values().toString();
    }

    public Stream<T> valueStream() {
        return this.map.values().stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassObjectMap)) {
            return false;
        }
        ClassObjectMap that = (ClassObjectMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public <U extends T> U putIfNotExists(U element) {
        Optional<?> o = this.get(element.getClass());
        if (!o.isPresent()) {
            this.put(element);
            return element;
        }
        return (U)o.get();
    }
}

