/*
 * Decompiled with CFR 0.152.
 */
package simulation.SimulationsHelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import maschine.Maschine;
import rollenbelegung.ErmittelteBelegungen;
import rollenbelegung.MaschinenBelegung;
import rollenbelegung.MitarbeiterBelegung;
import util.Pair;
import zeit.eintraege.BelegungsEintrag;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;

public final class BelegungsHelper {
    private BelegungsHelper() {
    }

    public static BelegungsHelper create() {
        return new BelegungsHelper();
    }

    public Pair<Collection<MaschinenBelegungEintrag>, Collection<MenschBelegungEintrag>> ermittleFehlendeBelegungen(ErmittelteBelegungen ermittelteBelegungen) {
        ArrayList maschinenBelegungen = new ArrayList();
        for (Maschine maschine : ermittelteBelegungen.getMaschinenbelegungen().keySet()) {
            maschinenBelegungen.addAll(ermittelteBelegungen.getMaschinenbelegungen().get(maschine).getBelegung().stream().filter(maschinenBelegungEintrag -> !this.hatPassendeMitarbeiterBelegung(maschine, (MaschinenBelegungEintrag)maschinenBelegungEintrag, ermittelteBelegungen.getMitarbeiterbelegungen().values())).collect(Collectors.toSet()));
        }
        Collection mitarbeiterBelegungen = ermittelteBelegungen.getMitarbeiterbelegungen().values().stream().flatMap(mitarbeiterBelegung -> mitarbeiterBelegung.getBelegung().stream()).filter(menschBelegungEintrag -> !this.hatPassendeMaschinenBelegung((MenschBelegungEintrag)menschBelegungEintrag, ermittelteBelegungen.getMaschinenbelegungen())).collect(Collectors.toSet());
        return Pair.create(maschinenBelegungen, (Object)mitarbeiterBelegungen);
    }

    private boolean hatPassendeMitarbeiterBelegung(Maschine maschine, MaschinenBelegungEintrag maschinenBelegungEintrag, Collection<MitarbeiterBelegung> mitarbeiterbelegungen) {
        return mitarbeiterbelegungen.stream().flatMap(mitarbeiterBelegung -> mitarbeiterBelegung.getBelegung().stream()).anyMatch(menschBelegungEintrag -> menschBelegungEintrag.getMaschineDieBedientWird().equals((Object)maschine) && menschBelegungEintrag.gleicherZeitraumUndProduktionsauftrag((BelegungsEintrag)maschinenBelegungEintrag));
    }

    private boolean hatPassendeMaschinenBelegung(MenschBelegungEintrag menschBelegungEintrag, Map<Maschine, MaschinenBelegung> maschinenbelegungen) {
        for (Map.Entry<Maschine, MaschinenBelegung> maschineUndBelegungen : maschinenbelegungen.entrySet()) {
            boolean matches;
            if (!maschineUndBelegungen.getKey().equals((Object)menschBelegungEintrag.getMaschineDieBedientWird()) || !(matches = maschineUndBelegungen.getValue().getBelegung().stream().anyMatch(maschinenBelegungEintrag -> maschinenBelegungEintrag.gleicherZeitraumUndProduktionsauftrag((BelegungsEintrag)menschBelegungEintrag)))) continue;
            return true;
        }
        return false;
    }
}

