/*
 * Decompiled with CFR 0.152.
 */
package auftraege.auftragsBildungsParameter;

import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameter;
import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameterVisitor;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariablenVisitor;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Beilagenart;
import auftraege.auftragsBildungsParameter.states.BeilagenArtenErlaubt;
import auftraege.auftragsBildungsParameter.states.BeilagenArtenState;
import auftraege.auftragsBildungsParameter.states.BeilagenArtenVerboten;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import util.exceptions.BeilagenAnzahlOutOfBoundsException;

public final class BeilagenArten
implements AusschliessenderParameter,
DokumentenklassenVariable {
    public static final BeilagenArten EMPTY = BeilagenArten.createMitErlaubten(Collections.unmodifiableSet(new HashSet()));
    private final BeilagenArtenState state;

    private BeilagenArten(BeilagenArtenState state) {
        this.state = state;
    }

    public static BeilagenArten createMitVerbotenen(Set<Beilagenart> beilagenarten) {
        return new BeilagenArten(new BeilagenArtenVerboten(beilagenarten));
    }

    public static BeilagenArten createMitErlaubten(Set<Beilagenart> beilagenarten) {
        return new BeilagenArten(new BeilagenArtenErlaubt(beilagenarten));
    }

    public static BeilagenArten createEmpty() {
        return BeilagenArten.createMitErlaubten(new HashSet<Beilagenart>());
    }

    public static BeilagenArten createMitErlaubten(String s) {
        return BeilagenArten.createMitErlaubten(Arrays.stream(s.split(",")).map(String::trim).map(Beilagenart::new).collect(Collectors.toSet()));
    }

    @Override
    public <T> T accept(AusschliessenderParameterVisitor<T> v) {
        return v.handle(this);
    }

    public Boolean contains(Beilagenart beilagenart) {
        return this.state.contains(beilagenart);
    }

    @Override
    public <T> T accept(DokumentenklassenVariablenVisitor<T> v) {
        return v.handle(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeilagenArten)) {
            return false;
        }
        BeilagenArten that = (BeilagenArten)o;
        return this.state.beilagenarten.equals(that.state.beilagenarten) && this.state.getClass().equals(that.state.getClass());
    }

    public int hashCode() {
        return this.state.beilagenarten.hashCode();
    }

    public Set<Beilagenart> getBeilagenarten() {
        return this.state.getBeilagenarten();
    }

    public boolean containsAll(Set<Beilagenart> beilagenarten) {
        for (Beilagenart current : beilagenarten) {
            if (this.contains(current).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public BeilagenArten addBeilagenarten(Set<Beilagenart> beilagenarten) throws UnsupportedOperationException {
        try {
            this.getBeilagenarten().addAll(beilagenarten);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Der statischen BeilagenArten.EMPTY darf kein Element hinzugef\u00fcgt werden!", e);
        }
        return this;
    }

    public int calculateUmruestvorgaengeZuNeuerBeilagenArt(BeilagenArten that, int begrenzung) {
        int elementsNoetigZuEntfernen;
        Set<Beilagenart> thatsBeilagenarten = that.getBeilagenarten();
        Map<Boolean, List<Beilagenart>> bereitsVorhandeneElementeInAuftrag = thatsBeilagenarten.stream().collect(Collectors.partitioningBy(this.getBeilagenarten()::contains));
        int idk = bereitsVorhandeneElementeInAuftrag.get(false).size() + this.getBeilagenarten().size() - begrenzung;
        int n = elementsNoetigZuEntfernen = idk < 0 ? 0 : idk;
        if (this.getBeilagenarten().size() + bereitsVorhandeneElementeInAuftrag.get(false).size() - elementsNoetigZuEntfernen > begrenzung) {
            throw new BeilagenAnzahlOutOfBoundsException("Der Beilagenumbau ist nicht unterhalb der Begrenzung zu realisieren.");
        }
        return elementsNoetigZuEntfernen + bereitsVorhandeneElementeInAuftrag.get(false).size();
    }

    public int getAnzahl() {
        return this.getBeilagenarten().size();
    }
}

