/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <T> List<T> concat(Collection<? extends T> collection1, Collection<? extends T> collection2) {
        return Stream.concat(collection1.stream(), collection2.stream()).collect(Collectors.toList());
    }

    public static <T> List<T> intersect(Collection<? extends T> c1, Collection<? extends T> c2) {
        return c1.stream().filter(c2::contains).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> List<T> createList(T ... t) {
        return Arrays.asList(t);
    }

    @SafeVarargs
    public static <T> Set<T> createSet(T ... t) {
        return new HashSet<T>(Arrays.asList(t));
    }
}

