/*
 * Decompiled with CFR 0.152.
 */
package util.testutilities;

import util.testutilities.Executable;

public final class AssertThrows {
    public static <T extends Exception> T assertThrows(Class<T> expectedType, Executable executable) {
        try {
            executable.execute();
        }
        catch (Exception actualException) {
            if (expectedType.isInstance(actualException)) {
                return (T)actualException;
            }
            throw new AssertionError(String.format("Unexpected exception type thrown, expected: %s, actual: %s", expectedType.getName(), actualException.getClass().getName()), actualException);
        }
        throw new AssertionError((Object)String.format("Expected %s to be thrown, but nothing was thrown.", expectedType.getSimpleName()));
    }

    private AssertThrows() {
    }
}

