/*
 * Decompiled with CFR 0.152.
 */
package zeit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import zeit.Kalender;
import zeit.KalenderEintragNichtErlaubtException;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragGenerell;
import zeit.eintraege.KalenderEintragTyp;
import zeit.eintraege.KalenderEintragVisitor;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;

public class MaschinenKalender
extends Kalender {
    private static final KalenderEintragTyp DEFAULT_TYP = KalenderEintragTyp.VERFUEGBAR;
    private static final Collection<KalenderEintragTyp> ERLAUBTE_TYPEN = new HashSet<KalenderEintragTyp>();

    @Override
    protected void pruefeKalenderEintrag(KalenderEintrag eintrag) {
        if (!ERLAUBTE_TYPEN.contains((Object)eintrag.getTyp())) {
            throw new KalenderEintragNichtErlaubtException(String.format("Der Typ %s ist nicht erlaubt f\u00fcr Maschinenkalender", eintrag));
        }
        if (eintrag.accept(new KalenderEintragVisitor<Boolean>(){

            @Override
            public Boolean handle(MaschinenBelegungEintrag maschinenBelegungEintrag) {
                return false;
            }

            @Override
            public Boolean handle(MenschBelegungEintrag menschBelegungEintrag) {
                return true;
            }

            @Override
            public Boolean handle(KalenderEintragGenerell kalenderEintragGenerell) {
                return false;
            }
        }).booleanValue()) {
            throw new KalenderEintragNichtErlaubtException("Der \u00fcbergebene MenschBelegungsEintrag kann einem Maschinenkalender nicht hinzugef\u00fcgt werden!");
        }
    }

    @Override
    protected Optional<KalenderEintrag> createDefaultEintragZuTag(LocalDate tag) {
        return Optional.of(KalenderEintragGenerell.createWholeDay(tag, DEFAULT_TYP));
    }

    @Override
    public long getArbeitszeit(LocalDate tag, ChronoUnit einheit) {
        LocalDateTime fixedDate = LocalDateTime.now();
        long zeitFuerEinenTagInEinheit = einheit.between(fixedDate, fixedDate.plusDays(1L));
        return zeitFuerEinenTagInEinheit - this.getEintraegeZuTag(tag).stream().filter(kalenderEintrag -> kalenderEintrag.getTyp() == KalenderEintragTyp.WARTUNG).mapToLong(kalenderEintrag -> einheit.between(kalenderEintrag.getVon(), kalenderEintrag.getBis())).sum();
    }

    public Set<MaschinenBelegungEintrag> getBelegungen() {
        final HashSet<MaschinenBelegungEintrag> result = new HashSet<MaschinenBelegungEintrag>();
        for (Set<KalenderEintrag> eintraege : this.getEintraege().values()) {
            for (KalenderEintrag eintrag : eintraege) {
                eintrag.accept(new KalenderEintragVisitor<Void>(){

                    @Override
                    public Void handle(MaschinenBelegungEintrag maschinenBelegungEintrag) {
                        result.add(maschinenBelegungEintrag);
                        return null;
                    }

                    @Override
                    public Void handle(MenschBelegungEintrag menschBelegungEintrag) {
                        return null;
                    }

                    @Override
                    public Void handle(KalenderEintragGenerell kalenderEintragGenerell) {
                        return null;
                    }
                });
            }
        }
        return result;
    }

    static {
        ERLAUBTE_TYPEN.add(KalenderEintragTyp.WARTUNG);
        ERLAUBTE_TYPEN.add(KalenderEintragTyp.BELEGT);
    }
}

