/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import auftraege.ProduktionsAuftrag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.measure.Quantity;
import maschine.Maschine;
import material.Material;
import material.MaterialMitMessung;
import mensch.Mitarbeiter;
import rollenbelegung.ErmittelteBelegungen;
import simulation.PruefErgebnisBuilder;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;

public final class PruefErgebnis {
    private final ErmittelteBelegungen gepruefteBelegungen;
    private final Collection<Mitarbeiter> ueberbuchteMitarbeiter;
    private final Collection<Maschine> ueberbuchteMaschinen;
    private final Collection<MenschBelegungEintrag> mitarbeiterbelegungenOhneMaschinenbelegung;
    private final Collection<MaschinenBelegungEintrag> maschinenbelegungenOhneMitarbeiterbelegung;
    private final Map<Mitarbeiter, Collection<MenschBelegungEintrag>> fehlendeFaehigkeitenFuerBelegungenProMitarbeiter;
    private final Collection<ProduktionsAuftrag> produktionsAuftraegeMitFehlendenBelegungen;
    private final Collection<MaterialMitMessung<?>> verbrauchtesMaterial;
    private final Collection<MaterialMitMessung<?>> verfuegbaresMaterial;

    PruefErgebnis(Collection<Mitarbeiter> ueberbuchteMitarbeiter, Collection<Maschine> ueberbuchteMaschinen, Collection<MenschBelegungEintrag> mitarbeiterbelegungenOhneMaschinenbelegung, Collection<MaschinenBelegungEintrag> maschinenbelegungenOhneMitarbeiterbelegung, Map<Mitarbeiter, Collection<MenschBelegungEintrag>> fehlendeFaehigkeitenFuerBelegungenProMitarbeiter, Collection<ProduktionsAuftrag> produktionsAuftraegeMitFehlendenBelegungen, Collection<MaterialMitMessung<?>> verbrauchtesMaterial, Collection<MaterialMitMessung<?>> verfuegbaresMaterial, ErmittelteBelegungen gepruefteBelegungen) {
        this.ueberbuchteMitarbeiter = ueberbuchteMitarbeiter;
        this.ueberbuchteMaschinen = ueberbuchteMaschinen;
        this.mitarbeiterbelegungenOhneMaschinenbelegung = mitarbeiterbelegungenOhneMaschinenbelegung;
        this.maschinenbelegungenOhneMitarbeiterbelegung = maschinenbelegungenOhneMitarbeiterbelegung;
        this.fehlendeFaehigkeitenFuerBelegungenProMitarbeiter = fehlendeFaehigkeitenFuerBelegungenProMitarbeiter;
        this.produktionsAuftraegeMitFehlendenBelegungen = produktionsAuftraegeMitFehlendenBelegungen;
        this.verbrauchtesMaterial = verbrauchtesMaterial;
        this.verfuegbaresMaterial = verfuegbaresMaterial;
        this.gepruefteBelegungen = gepruefteBelegungen;
    }

    static PruefErgebnisBuilder builder() {
        return PruefErgebnisBuilder.create();
    }

    public ErmittelteBelegungen getGepruefteBelegungen() {
        return this.gepruefteBelegungen;
    }

    public Collection<ProduktionsAuftrag> getProduktionsAuftraegeMitFehlendenBelegungen() {
        return Collections.unmodifiableCollection(this.produktionsAuftraegeMitFehlendenBelegungen);
    }

    public Collection<Mitarbeiter> getUeberbuchteMitarbeiter() {
        return Collections.unmodifiableCollection(this.ueberbuchteMitarbeiter);
    }

    public Collection<Maschine> getUeberbuchteMaschinen() {
        return Collections.unmodifiableCollection(this.ueberbuchteMaschinen);
    }

    public boolean pruefungWarFehlerfrei() {
        return this.ueberBuchungLiegtNichtVor() && this.produktionsAuftraegeMitFehlendenBelegungen.isEmpty() && this.belegungenPassenZueinander() && this.fehlendeFaehigkeitenFuerBelegungenProMitarbeiter.isEmpty() && this.istAusreichendMaterialVorhanden();
    }

    private boolean belegungenPassenZueinander() {
        return this.mitarbeiterbelegungenOhneMaschinenbelegung.isEmpty() && this.maschinenbelegungenOhneMitarbeiterbelegung.isEmpty();
    }

    private boolean ueberBuchungLiegtNichtVor() {
        return this.ueberbuchteMaschinen.isEmpty() && this.ueberbuchteMitarbeiter.isEmpty();
    }

    public Collection<MenschBelegungEintrag> getMitarbeiterbelegungenOhneMaschinenbelegung() {
        return Collections.unmodifiableCollection(this.mitarbeiterbelegungenOhneMaschinenbelegung);
    }

    public Collection<MaschinenBelegungEintrag> getMaschinenbelegungenOhneMitarbeiterbelegung() {
        return Collections.unmodifiableCollection(this.maschinenbelegungenOhneMitarbeiterbelegung);
    }

    public Map<Mitarbeiter, Collection<MenschBelegungEintrag>> getFehlendeFaehigkeitenFuerBelegungenProMitarbeiter() {
        return Collections.unmodifiableMap(this.fehlendeFaehigkeitenFuerBelegungenProMitarbeiter);
    }

    public Collection<MaterialMitMessung<?>> getVerbrauchtesMaterial() {
        return Collections.unmodifiableCollection(this.verbrauchtesMaterial);
    }

    public Collection<MaterialMitMessung<?>> getVerfuegbaresMaterial() {
        return Collections.unmodifiableCollection(this.verfuegbaresMaterial);
    }

    public List<MaterialMitMessung<?>> getFehlendesMaterial() {
        return this.verbrauchtesMaterial.stream().map(einVerbrauchtesMaterial -> {
            Optional<MaterialMitMessung> passendesMaterial = this.verfuegbaresMaterial.stream().filter(it -> it.getMaterial().equals(einVerbrauchtesMaterial.getMaterial())).findFirst();
            if (!passendesMaterial.isPresent()) {
                return einVerbrauchtesMaterial;
            }
            return this.bestimmeDifferenzDerMaterialien((MaterialMitMessung)einVerbrauchtesMaterial, passendesMaterial.get());
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private MaterialMitMessung<?> bestimmeDifferenzDerMaterialien(MaterialMitMessung einVerbrauchtesMaterial, MaterialMitMessung vorhandenesPassendesMaterial) {
        Quantity differenz = einVerbrauchtesMaterial.getMessung().subtract(vorhandenesPassendesMaterial.getMessung());
        if (differenz.getValue().doubleValue() > 0.0) {
            return MaterialMitMessung.create((Material)vorhandenesPassendesMaterial.getMaterial(), (Quantity)differenz);
        }
        return null;
    }

    public boolean istAusreichendMaterialVorhanden() {
        return this.getFehlendesMaterial().isEmpty();
    }

    public Map<Class<? extends Material>, Quantity> getMaterialVerbrauchProMaterialKategorie() {
        Map messungenProMaterialTyp = this.getVerbrauchtesMaterial().stream().collect(Collectors.groupingBy(m -> m.getMaterial().getClass(), Collectors.mapping(MaterialMitMessung::getMessung, Collectors.reducing(Quantity::add))));
        return messungenProMaterialTyp.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Quantity)((Optional)e.getValue()).get()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PruefErgebnis)) {
            return false;
        }
        PruefErgebnis that = (PruefErgebnis)o;
        return com.google.common.base.Objects.equal((Object)this.gepruefteBelegungen, (Object)that.gepruefteBelegungen) && com.google.common.base.Objects.equal(this.ueberbuchteMitarbeiter, that.ueberbuchteMitarbeiter) && com.google.common.base.Objects.equal(this.ueberbuchteMaschinen, that.ueberbuchteMaschinen) && com.google.common.base.Objects.equal(this.mitarbeiterbelegungenOhneMaschinenbelegung, that.mitarbeiterbelegungenOhneMaschinenbelegung) && com.google.common.base.Objects.equal(this.maschinenbelegungenOhneMitarbeiterbelegung, that.maschinenbelegungenOhneMitarbeiterbelegung) && com.google.common.base.Objects.equal(this.fehlendeFaehigkeitenFuerBelegungenProMitarbeiter, that.fehlendeFaehigkeitenFuerBelegungenProMitarbeiter) && com.google.common.base.Objects.equal(this.produktionsAuftraegeMitFehlendenBelegungen, that.produktionsAuftraegeMitFehlendenBelegungen) && com.google.common.base.Objects.equal(this.verbrauchtesMaterial, that.verbrauchtesMaterial) && com.google.common.base.Objects.equal(this.verfuegbaresMaterial, that.verfuegbaresMaterial);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.gepruefteBelegungen, this.ueberbuchteMitarbeiter, this.ueberbuchteMaschinen, this.mitarbeiterbelegungenOhneMaschinenbelegung, this.maschinenbelegungenOhneMitarbeiterbelegung, this.fehlendeFaehigkeitenFuerBelegungenProMitarbeiter, this.produktionsAuftraegeMitFehlendenBelegungen, this.verbrauchtesMaterial, this.verfuegbaresMaterial});
    }
}

