/*
 * Decompiled with CFR 0.152.
 */
package simulation.SimulationsHelper;

import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import simulation.exceptions.SimulationsException;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;

public final class SimulationsKonstanten {
    private static final Map<ChronoUnit, Unit<Time>> ZEIT_EINHEITEN_ZUORDNUNG = new HashMap<ChronoUnit, Unit<Time>>();
    static final String SIMULATION_NICHT_MOEGLICH = "Simulation nicht m\u00f6glich, wenn keine Belegungen geplant wurden";
    public static final ChronoUnit DEFAULT_JAVA_ZEIT_EINHEIT;
    public static final ComparableQuantity<Time> NEUTRALE_ZEIT;

    private SimulationsKonstanten() {
    }

    static Unit<Time> getZeitEinheit(ChronoUnit berechnungsZeitEinheit) {
        Unit<Time> result = ZEIT_EINHEITEN_ZUORDNUNG.get(berechnungsZeitEinheit);
        if (Objects.isNull(result)) {
            throw new SimulationsException(String.format("Die Zeiteinheit %s wird nicht unterst\u00fctzt. Nur folgende Zeiteinheiten werden unterst\u00fctzt: %s", berechnungsZeitEinheit, ZEIT_EINHEITEN_ZUORDNUNG.keySet()));
        }
        return result;
    }

    static {
        ZEIT_EINHEITEN_ZUORDNUNG.put(ChronoUnit.SECONDS, (Unit<Time>)Units.SECOND);
        ZEIT_EINHEITEN_ZUORDNUNG.put(ChronoUnit.MINUTES, (Unit<Time>)Units.MINUTE);
        ZEIT_EINHEITEN_ZUORDNUNG.put(ChronoUnit.HOURS, (Unit<Time>)Units.HOUR);
        DEFAULT_JAVA_ZEIT_EINHEIT = ChronoUnit.MINUTES;
        NEUTRALE_ZEIT = Quantities.getQuantity((Number)0, (Unit)Units.SECOND);
    }
}

