package de.fhdw.gaming.ipspiel21.evolution;

import java.util.ArrayList;

/**
 * Implements @EvolutionPlayer.
 */
public abstract class EvolutionPlayerImpl implements EvolutionPlayer {

    /**
     * the full memory of the player. Is a collection of game histories.
     */
    private GameHistoryCollection memory;

    /**
     * Creates an evolution player.
     *
     */
    public EvolutionPlayerImpl() {
        super();
        this.memory = new GameHistoryCollectionImpl(new ArrayList<GameHistory>());
    }

    @Override
    public GameHistoryCollection getGameHistoryCollection() {
        return this.memory;
    }

    @Override
    public void setGameHistoryCollection(final GameHistoryCollection gameHistoryCollection) {
        this.memory = gameHistoryCollection;
    }

}
