/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.tictactoe.strategy.best;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.Evaluation;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.NextMoveGenerator;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.impl.AlphaBetaImpl;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToeFieldState;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToeStrategy;
import de.fhdw.gaming.ipspiel21.tictactoe.core.moves.TicTacToeMove;
import de.fhdw.gaming.ipspiel21.tictactoe.core.moves.factory.TicTacToeMoveFactory;
import de.fhdw.gaming.ipspiel21.tictactoe.strategy.best.TicTacToeNextMoveGenerator;
import evaluation.TicTacToeEvaluation;
import java.util.ArrayList;
import java.util.Optional;

public final class TicTacToeBestMoveStrategy
implements TicTacToeStrategy {
    private final TicTacToeMoveFactory moveFactory;

    TicTacToeBestMoveStrategy(TicTacToeMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<TicTacToeMove> computeNextMove(int gameId, TicTacToePlayer player, TicTacToeState state) throws GameException {
        ArrayList fields = new ArrayList(state.getBoard().getFieldsBeing(TicTacToeFieldState.EMPTY).values());
        if (fields.isEmpty()) {
            return Optional.empty();
        }
        AlphaBetaImpl algorithm = new AlphaBetaImpl();
        return algorithm.getBestMove(3, (Player)player, (NextMoveGenerator)new TicTacToeNextMoveGenerator(this.moveFactory), (State)state, (Evaluation)new TicTacToeEvaluation());
    }

    public String toString() {
        return TicTacToeBestMoveStrategy.class.getSimpleName();
    }
}

