package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements {@link DilemmaStrategy} (evolving) with the periodically kind strategy. The player periodically stays
 * silent two times and then confesses.
 */
public final class DilemmaPeriodicallyKindStrategy implements DilemmaStrategy {

    /**
     * Factory for creating Dilemma moves.
     */
    private final DilemmaMoveFactory moveFactory;

    /**
     * Creates an {@link DilemmaPeriodicallyKindStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    public DilemmaPeriodicallyKindStrategy(final DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<DilemmaMove> computeNextMove(final int gameId, final DilemmaPlayer player,
            final DilemmaState state) throws GameException, InterruptedException {

        if (player.getGameHistoryCollection().numberOfPlayedGames() % 3 == 2) {
            return Optional.of(moveFactory.createNoMove());
        } else {
            return Optional.of(moveFactory.createYesMove());
        }
    }

    @Override
    public String toString() {
        return DilemmaPeriodicallyKindStrategy.class.getSimpleName();
    }
}
