package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;
import de.fhdw.gaming.ipspiel21.evolution.GameHistoryCollection;

/**
 * Implements {@link DilemmaStrategy} with the prober strategy. spielt die ersten drei Züge kooperieren, verraten,
 * verraten und verrät fortan, wenn der Gegner im zweiten und dritten Zug kooperiert hat, spielt sonst Tit for Tat.
 * 
 */
public final class DilemmaProberStrategy implements DilemmaStrategy {
    /**
     * The factory for creating Dilemma moves.
     */
    private final DilemmaMoveFactory moveFactory;

    /**
     * .
     */
    private final DilemmaTitForTatStrategy dilemmaTitForTatStrategy;

    /**
     * Creates an {@link DilemmaPavlovStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    public DilemmaProberStrategy(final DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.dilemmaTitForTatStrategy = new DilemmaTitForTatStrategy(this.moveFactory);
    }

    @Override
    public Optional<DilemmaMove> computeNextMove(final int gameId, final DilemmaPlayer player, final DilemmaState state)
            throws GameException, InterruptedException {
        final Integer games = player.getGameHistoryCollection().numberOfPlayedGames();
        switch (games) {
        case 0:
            return Optional.of(this.moveFactory.createYesMove());

        case 1:
        case 2:
            return Optional.of(this.moveFactory.createNoMove());
        default:
            return this.confess(state.getOtherPlayer(player).getGameHistoryCollection())
                    ? Optional.of(this.moveFactory.createNoMove())
                    : this.dilemmaTitForTatStrategy.computeNextMove(gameId, player, state);
        }
    }

    /**
     * .
     * 
     * @param historyCollection
     * @return if you should confess or play tit for tat
     */
    private boolean confess(final GameHistoryCollection historyCollection) {
        return historyCollection.getSpecificGameHistory(historyCollection.numberOfPlayedGames() - 2).getMove(0)
                .equals(this.moveFactory.createYesMove())
                && historyCollection.getSpecificGameHistory(historyCollection.numberOfPlayedGames() - 3).getMove(0)
                        .equals(this.moveFactory.createYesMove());
    }

    @Override
    public String toString() {
        return DilemmaProberStrategy.class.getSimpleName();
    }
}
