/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-Dilemma.
 *
 * Ipspiel21-Dil is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-Dil is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-Dilemma. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;

/**
 * Says "no".
 */
public class DilemmaConfessMove extends AbstractDilemmaMove {

    /**
     * constructor for DilemmaConfessMove with implements the {@link AbstractDilemmaMove}.
     */
    public DilemmaConfessMove() {
        super("ConfessMove");
    }

    @Override
    public void applyTo(final DilemmaState state, final DilemmaPlayer player) throws GameException {
        state.setAnswer(player, this);
    }
}
