package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.factory.DilemmaStrategyFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements {@link DilemmaStrategyFactory} by creating a {@link DilemmaPunisherStrategy}.
 */
final class DilemmaPunisherStrategyFactory implements DilemmaStrategyFactory {

    @Override
    public DilemmaStrategy create(final DilemmaMoveFactory moveFactory) {
        return new DilemmaPunisherStrategy(moveFactory);
    }

}
