/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.evolution;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.ipspiel21.evolution.GameHistory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GameHistoryImpl
implements GameHistory {
    private final List<Move<?, ?>> myMoves = new ArrayList();
    private final List<Move<?, ?>> opponentMoves = new ArrayList();
    private final Integer gameId;
    private Optional<Double> myOutcome;
    private Optional<Double> opponentOutcome;

    public GameHistoryImpl(Integer gameId) {
        this.gameId = gameId;
        this.myOutcome = Optional.empty();
        this.opponentOutcome = Optional.empty();
    }

    @Override
    public Move<?, ?> getMove(Integer index) {
        return this.myMoves.get(index);
    }

    @Override
    public Move<?, ?> getOpponentMove(Integer index) {
        return this.opponentMoves.get(index);
    }

    @Override
    public Optional<Double> getOutcome() {
        return this.myOutcome;
    }

    @Override
    public void setOutcome(boolean opponent, Optional<Double> outcome) {
        if (opponent) {
            this.opponentOutcome = outcome;
        } else {
            this.myOutcome = outcome;
        }
    }

    @Override
    public Optional<Double> getOpponentOutcome() {
        return this.opponentOutcome;
    }

    @Override
    public Integer numberOfPlayedMoves() {
        return this.myMoves.size();
    }

    @Override
    public Integer getGameId() {
        return this.gameId;
    }

    @Override
    public void addMove(boolean opponent, Move<?, ?> move) {
        if (opponent) {
            this.opponentMoves.add(0, move);
        } else {
            this.myMoves.add(0, move);
        }
    }
}

