/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Logger
implements Observer {
    public void started(Game<?, ?, ?, ?> game, State<?, ?> state) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Startet!\n\tInitial state -> " + state + "\n");
    }

    public void nextPlayersComputed(Game<?, ?, ?, ?> game, State<?, ?> state, Set<? extends Player> players) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Calculated next players!\n\t" + players.stream().map(Object::toString).collect(Collectors.joining(", ")) + "\n");
    }

    public void illegalPlayerRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player player) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Illegal Player rejected!\n\t" + player + "\n");
    }

    public void legalMoveApplied(Game<?, ?, ?, ?> game, State<?, ?> state, Player player, Move<?, ?> move) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Legal move!\n\t" + move + " by " + player + "\n\tNew state -> " + state + "\n");
    }

    public void illegalMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player player, Optional<Move<?, ?>> move, String reason) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Illegal Move rejected!\n\t" + move + "\n\t" + player + "\n\t" + reason + "\n");
    }

    public void overdueMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player player, Optional<Move<?, ?>> chosenMove) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Over due move rejected!\n\t" + player + "\n\t" + chosenMove + "\n");
    }

    public void playerResigned(Game<?, ?, ?, ?> game, State<?, ?> state, Player player) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Player resigned!\n\t" + player + "\n");
    }

    public void playerOvertaken(Game<?, ?, ?, ?> game, State<?, ?> state, Player overtakenPlayer, Player overtakingPlayer) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Player overtaken!\n\t" + overtakenPlayer + "\n\tby\n\t" + overtakingPlayer + "\n");
    }

    public void finished(Game<?, ?, ?, ?> game, State<?, ?> state) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Finished!\n\tFinal state: " + state + "\n");
    }
}

