package de.fhdw.gaming.ipspiel21.freizeit.strategy;

import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitStrategy;
import de.fhdw.gaming.ipspiel21.freizeit.domain.factory.FreizeitStrategyFactory;
import de.fhdw.gaming.ipspiel21.freizeit.moves.factory.FreizeitMoveFactory;

/**
 * Implements {@link DemoStrategyFactory} by creating a {@link FreizeitBalancedSoccerFavoriteStrategyFactory}.
 *
 * @author Leonard Frank
 */
public final class FreizeitBalancedSoccerFavoriteStrategyFactory implements FreizeitStrategyFactory {

    @Override
    public FreizeitStrategy create(final FreizeitMoveFactory moveFactory) {
        return new FreizeitBalancedSoccerFavoriteStrategy(moveFactory);
    }

}
