/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.evolution.EvolutionPlayerImpl;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayer;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitState;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.AbstractFreizeitMove;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class FreizeitPlayerImpl
extends EvolutionPlayerImpl
implements FreizeitPlayer {
    private final FreizeitState gameState;
    private final String name;
    private final Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> possibleOutcomes;

    FreizeitPlayerImpl(FreizeitState gameState, String name, Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> possibleOutcomes) {
        this.gameState = gameState;
        this.name = Objects.requireNonNull(name, "name");
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
    }

    public String toString() {
        return String.format("FreizeitPlayer[name=%s, state=%s, outcome=%s]", this.name, this.getState(), this.getOutcome());
    }

    public boolean equals(Object obj) {
        if (obj instanceof FreizeitPlayerImpl) {
            FreizeitPlayerImpl other = (FreizeitPlayerImpl)obj;
            return this.name.equals(other.name) && this.getState().equals((Object)other.getState()) && this.getOutcome().equals(other.getOutcome());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    public PlayerState getState() {
        return this.gameState.getPlayerState(this.name);
    }

    public Optional<Double> getOutcome() {
        return this.gameState.getPlayerOutcome(this.name);
    }

    @Override
    public FreizeitPlayer deepCopy(FreizeitState newGameState) {
        return new FreizeitPlayerImpl(newGameState, this.name, this.possibleOutcomes);
    }
}

