package de.fhdw.gaming.ipspiel21.freizeit.domain.impl;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 * Prints events of a {@link Game game}.
 *
 * @author Robby Rabbitman (see Rock Paper Scissors)
 *
 */
// https://pmd.github.io/latest/pmd_userdocs_suppressing_warnings.html
// https://stackoverflow.com/questions/5017569/unsupported-suppresswarningspmd-donotcallsystemexit
@SuppressWarnings("PMD.AvoidDuplicateLiterals")
public class Logger implements Observer {

    @Override
    public void started(final Game<?, ?, ?, ?> game, final State<?, ?> state) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Startet!\n\tInitial state -> " + state + "\n");
    }

    @Override
    public void nextPlayersComputed(final Game<?, ?, ?, ?> game, final State<?, ?> state,
            final Set<? extends Player> players) throws InterruptedException {
        System.out.println(
                "Game " + game.getId() + ": Calculated next players!\n\t"
                        + players.stream().map(Player::toString).collect(Collectors.joining(", ")) + "\n");
    }

    @Override
    public void illegalPlayerRejected(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player)
            throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Illegal Player rejected!\n\t" + player + "\n");
    }

    @Override
    public void legalMoveApplied(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player,
            final Move<?, ?> move) throws InterruptedException {
        System.out.println(
                "Game " + game.getId() + ": Legal move!\n\t" + move + " by " + player + "\n\tNew state -> " + state
                        + "\n");
    }

    @Override
    public void illegalMoveRejected(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player,
            final Optional<Move<?, ?>> move, final String reason) throws InterruptedException {
        System.out.println(
                "Game " + game.getId() + ": Illegal Move rejected!\n\t" + move + "\n\t" + player + "\n\t" + reason
                        + "\n");
    }

    @Override
    public void overdueMoveRejected(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player,
            final Optional<Move<?, ?>> chosenMove) throws InterruptedException {
        System.out.println(
                "Game " + game.getId() + ": Over due move rejected!\n\t" + player + "\n\t" + chosenMove + "\n");
    }

    @Override
    public void playerResigned(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player)
            throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Player resigned!\n\t" + player + "\n");
    }

    @Override
    public void playerOvertaken(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player overtakenPlayer,
            final Player overtakingPlayer) throws InterruptedException {
        System.out.println(
                "Game " + game.getId() + ": Player overtaken!\n\t" + overtakenPlayer + "\n\tby\n\t" + overtakingPlayer
                        + "\n");
    }

    @Override
    public void finished(final Game<?, ?, ?, ?> game, final State<?, ?> state) throws InterruptedException {
        System.out.println("Game " + game.getId() + ": Finished!\n\tFinal state: " + state + "\n");
    }

}
