/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayer;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayerBuilder;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitState;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.AbstractFreizeitMove;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class FreizeitStateImpl
implements FreizeitState {
    private final FreizeitPlayer firstPlayer;
    private final FreizeitPlayer secondPlayer;
    private final Map<FreizeitPlayer, AbstractFreizeitMove> playerMove;
    private final Map<String, PlayerState> playerStateMap;
    private final Map<String, Double> outcomePlayerMap;

    FreizeitStateImpl(FreizeitPlayerBuilder firstPlayerBuilder, FreizeitPlayerBuilder secondPlayerBuilder) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayerBuilder, "firstPlayerBuilder").build(this);
        this.secondPlayer = Objects.requireNonNull(secondPlayerBuilder, "secondPlayerBuilder").build(this);
        this.outcomePlayerMap = new LinkedHashMap<String, Double>();
        this.playerStateMap = new LinkedHashMap<String, PlayerState>();
        this.playerStateMap.put(this.firstPlayer.getName(), PlayerState.PLAYING);
        this.playerStateMap.put(this.secondPlayer.getName(), PlayerState.PLAYING);
        this.playerMove = new LinkedHashMap<FreizeitPlayer, AbstractFreizeitMove>();
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    FreizeitStateImpl(FreizeitStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy(this);
        this.secondPlayer = source.secondPlayer.deepCopy(this);
        this.outcomePlayerMap = new LinkedHashMap<String, Double>(source.outcomePlayerMap);
        this.playerStateMap = new LinkedHashMap<String, PlayerState>();
        this.playerStateMap.put(this.firstPlayer.getName(), source.playerStateMap.get(this.firstPlayer.getName()));
        this.playerStateMap.put(this.secondPlayer.getName(), source.playerStateMap.get(this.secondPlayer.getName()));
        this.playerMove = new LinkedHashMap<FreizeitPlayer, AbstractFreizeitMove>();
    }

    @Override
    public FreizeitPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public FreizeitPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("FreizeitState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FreizeitStateImpl) {
            FreizeitStateImpl other = (FreizeitStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public FreizeitState deepCopy() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, FreizeitPlayer> getPlayers() {
        LinkedHashMap<String, FreizeitPlayer> result = new LinkedHashMap<String, FreizeitPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public PlayerState getPlayerState(String playerName) throws IllegalArgumentException {
        PlayerState playerState = this.playerStateMap.get(playerName);
        if (playerState != null) {
            return playerState;
        }
        throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
    }

    public void setPlayerState(String playerName, PlayerState newState) throws IllegalArgumentException {
        if (this.playerStateMap.containsKey(playerName)) {
            this.playerStateMap.put(playerName, newState);
            if (newState.equals((Object)PlayerState.PLAYING)) {
                this.outcomePlayerMap.remove(playerName);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
        }
    }

    @Override
    public Optional<Double> getPlayerOutcome(String playerName) throws IllegalArgumentException {
        if (this.playerStateMap.containsKey(playerName)) {
            Double outcome = this.outcomePlayerMap.get(playerName);
            return outcome != null ? Optional.of(outcome) : FreizeitState.super.getPlayerOutcome(playerName);
        }
        throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
    }

    public void setPlayerOutcome(String playerName, double newOutcome) throws IllegalArgumentException {
        if (!this.playerStateMap.containsKey(playerName)) {
            throw new IllegalArgumentException(String.format("Unknown player %s was found.", playerName));
        }
        this.outcomePlayerMap.put(playerName, newOutcome);
    }

    @Override
    public AbstractFreizeitMove getPlayerMove(FreizeitPlayer player) {
        return this.playerMove.get(player);
    }

    public Set<FreizeitPlayer> computeNextPlayers() {
        LinkedHashSet<FreizeitPlayer> playersWithoutAnswer = new LinkedHashSet<FreizeitPlayer>();
        if (!this.playerMove.containsKey(this.getFirstPlayer())) {
            playersWithoutAnswer.add(this.firstPlayer);
        }
        if (!this.playerMove.containsKey(this.getSecondPlayer())) {
            playersWithoutAnswer.add(this.secondPlayer);
        }
        return playersWithoutAnswer;
    }

    public void nextTurn() {
        Set<FreizeitPlayer> playersWithoutAnswer = this.computeNextPlayers();
        if (playersWithoutAnswer.isEmpty()) {
            this.setNewOutcomes(this.firstPlayer, this.secondPlayer);
            this.setNewOutcomes(this.secondPlayer, this.firstPlayer);
            this.setNewPlayerState(this.firstPlayer);
            this.setNewPlayerState(this.secondPlayer);
        }
    }

    private void setNewOutcomes(FreizeitPlayer firstTurn, FreizeitPlayer secondTurn) {
        AbstractFreizeitMove firstPlayerMove = this.getPlayerMove(firstTurn);
        AbstractFreizeitMove secondPlayerMove = this.getPlayerMove(secondTurn);
        Double outcome = firstTurn.getPossibleOutcomes().get(firstPlayerMove).get(secondPlayerMove);
        this.setPlayerOutcome(firstTurn.getName(), outcome);
    }

    private void setNewPlayerState(FreizeitPlayer player) {
        if (player == null) {
            throw new IllegalArgumentException(String.format("The player was not found", player));
        }
        Optional<FreizeitPlayer> otherPlayer = this.getPlayers().values().stream().filter(player1 -> !player.equals(player1)).findAny();
        Optional outcome1Option = player.getOutcome();
        Optional<Optional> outcome2Option = otherPlayer.map(Player::getOutcome);
        if (outcome1Option.isEmpty() || outcome2Option.isEmpty() || outcome2Option.get().isEmpty()) {
            throw new IllegalArgumentException("At least one of the outcomes of the players was not found");
        }
        Double outcome1 = (Double)outcome1Option.get();
        Double outcome2 = (Double)outcome2Option.get().get();
        if (outcome1 > outcome2) {
            this.setPlayerState(player.getName(), PlayerState.WON);
        } else if (outcome1 < outcome2) {
            this.setPlayerState(player.getName(), PlayerState.LOST);
        } else {
            this.setPlayerState(player.getName(), PlayerState.DRAW);
        }
    }

    @Override
    public void setAnswer(FreizeitPlayer player, AbstractFreizeitMove answer) {
        try {
            if (this.playerMove.containsKey(player)) {
                throw new IllegalArgumentException(String.format("Player %s have already given an answer", player));
            }
            this.playerMove.put(player, answer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

