/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.evolution.EvolutionPlayerImpl;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlPlayer;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlState;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.SaidMove;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class KopfzahlPlayerImpl
extends EvolutionPlayerImpl
implements KopfzahlPlayer {
    private final KopfzahlState gameState;
    private final String name;
    private final Map<SaidMove, Map<SaidMove, Double>> possibleOutcomes;

    KopfzahlPlayerImpl(KopfzahlState gameState, String name, Map<SaidMove, Map<SaidMove, Double>> possibleOutcomes) {
        this.gameState = gameState;
        this.name = Objects.requireNonNull(name, "name");
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<SaidMove, Map<SaidMove, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
    }

    public String toString() {
        return String.format("KopfzahlPlayer[name=%s, state=%s, outcome=%s]", this.name, this.getState(), this.getOutcome());
    }

    public boolean equals(Object obj) {
        if (obj instanceof KopfzahlPlayerImpl) {
            KopfzahlPlayerImpl other = (KopfzahlPlayerImpl)obj;
            return this.name.equals(other.name) && this.getState().equals((Object)other.getState()) && this.getOutcome().equals(other.getOutcome());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<SaidMove, Map<SaidMove, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public KopfzahlPlayer deepCopy(KopfzahlState newGameState) {
        return new KopfzahlPlayerImpl(newGameState, this.name, this.possibleOutcomes);
    }

    public PlayerState getState() {
        return this.gameState.getPlayerState(this.name);
    }

    public Optional<Double> getOutcome() {
        return this.gameState.getPlayerOutcome(this.name);
    }
}

