/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahlkante.
 *
 * Ipspiel21-kopfzahlkante is free software: you can redistribute it and/or modify it under the terms
 * of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahlkante is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahlkante. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain;

import java.util.Optional;

import de.fhdw.gaming.core.domain.State;

/**
 * Represents the state of a Kopfzahlkante game.
 */
public interface KopfzahlkanteState extends State<KopfzahlkantePlayer, KopfzahlkanteState> {

    /**
     * Returns the first player.
     */
    KopfzahlkantePlayer getFirstPlayer();

    /**
     * Returns the second player.
     */
    KopfzahlkantePlayer getSecondPlayer();

    /**
     * new Default-Outcomes.
     */
    @Override
    default Optional<Double> getPlayerOutcome(final String playerName) throws IllegalArgumentException {
        switch (this.getPlayerState(playerName)) {
        case WON:
            return Optional.of(1.0);
        case LOST:
            return Optional.of(-1.0);
        case RESIGNED:
        case DRAW:
        case PLAYING:
        default:
            return Optional.empty();
        }
    }

    /**
     * Records the answer of a player.
     *
     * @param player The player.
     * @param answer The player's answer "Kopf", "Zahl" or "Kante").
     */
    void setAnswer(KopfzahlkantePlayer player, SaidMove answer);
}
