/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayer;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayerBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.SaidMove;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl.KopfzahlkantePlayerImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

final class KopfzahlkantePlayerBuilderImpl
implements KopfzahlkantePlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<SaidMove, Map<SaidMove, Double>>> possibleOutcomes = Optional.empty();

    KopfzahlkantePlayerBuilderImpl() {
    }

    @Override
    public KopfzahlkantePlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public KopfzahlkantePlayerBuilder changePossibleOutcomes(Map<SaidMove, Map<SaidMove, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public KopfzahlkantePlayer build(KopfzahlkanteState state) throws GameException {
        return new KopfzahlkantePlayerImpl(state, this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<SaidMove, Map<SaidMove, Double>> checkPossibleOutcomes(Map<SaidMove, Map<SaidMove, Double>> outcomes) {
        if (!KopfzahlkantePlayerBuilderImpl.isOutcomeNullOrEmptyOutterMap(outcomes) && !KopfzahlkantePlayerBuilderImpl.isOutcomeNullOrEmptyInnerMap(outcomes.values())) {
            return outcomes;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isOutcomeNullOrEmptyOutterMap(Map<SaidMove, Map<SaidMove, Double>> outcomes) {
        if (outcomes.isEmpty()) {
            throw new IllegalArgumentException("Possible outcomes are not defined for the player");
        }
        Iterator<Map<SaidMove, Double>> it = outcomes.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            throw new IllegalArgumentException("The input is not defined:" + it.next());
        }
        return false;
    }

    private static boolean isOutcomeNullOrEmptyInnerMap(Collection<Map<SaidMove, Double>> outcomes) {
        if (outcomes.isEmpty()) {
            throw new IllegalArgumentException("Possible outcomes are not defined for the player");
        }
        Iterator<Map<SaidMove, Double>> it = outcomes.iterator();
        while (it.hasNext()) {
            if (it.next().values() != null) continue;
            throw new IllegalArgumentException("The value is not defined: " + it.next());
        }
        return false;
    }
}

