package de.fhdw.gaming.ipspiel21.searchtrees.domain.impl;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 *
 * creates a pair of move and evaluation.
 *
 * @param <P>
 * @param <S>
 * @param <M>
 */
public class MoveEvaluationPair<P extends Player, S extends State<P, S>, M extends Move<P, S>> {
    /**
     * The actual move.
     */
    private final M move;
    /**
     * The actual evaluation.
     */
    private final Double evaluation;

    /**
     * Constructor of MoveEvaluationPair.
     *
     * @param move
     * @param evaluation
     */
    MoveEvaluationPair(final M move, final Double evaluation) {
        this.move = move;
        this.evaluation = evaluation;
    }

    /**
     * Get the actual move.
     *
     * @return the move.
     */
    public M getMove() {
        return this.move;
    }

    /**
     * Get the actual evaluation.
     *
     * @return the evaluation.
     */
    public Double getEvaluation() {
        return this.evaluation;
    }
}
