
package de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntStrategy;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.VierGewinntMove;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.factory.VierGewinntMoveFactory;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.event.VierGewinntBoardEventVisitor;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.event.VierGewinntMakeMoveBoardEvent;

/**
 * Implements {@link VierGewinntStrategy} by asking the user for a move.
 */
public final class VierGewinntInteractiveStrategy implements VierGewinntStrategy {

    /**
     * The factory for creating VierGewinnt moves.
     */
    private final VierGewinntMoveFactory moveFactory;

    /**
     * Creates an {@link VierGewinntInteractiveStrategy}.
     *
     * @param moveFactory The factory for creating VierGewinnt moves.
     */
    VierGewinntInteractiveStrategy(final VierGewinntMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    /**
     * Asks the user to choose a move.
     */
    @Override
    public Optional<VierGewinntMove> computeNextMove(final int gameId, final VierGewinntPlayer player,
            final VierGewinntState state) throws GameException {

        final Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiObserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }

        final AtomicReference<VierGewinntMove> move = new AtomicReference<>();
        provider.get().waitForEvent(player, state).accept(new VierGewinntBoardEventVisitor() {

            @Override
            public void handleMakeMove(final VierGewinntMakeMoveBoardEvent event) {
                move.setPlain(
                        VierGewinntInteractiveStrategy.this.moveFactory
                                .createMove(event.getFieldPosition()));
            }
        });

        return Optional.ofNullable(move.getPlain());
    }

    @Override
    public String toString() {
        return VierGewinntInteractiveStrategy.class.getSimpleName();
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void abortRequested(final int gameId) {
        final Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiObserverImpl.getEventProvider(gameId);
        if (!provider.isEmpty()) {
            provider.get().cancelWaiting();
        }
    }
}
