package de.fhdw.ipspiel21.viergewinnt.strategies.group1.strategy;

import java.util.Collection;
import java.util.stream.Collectors;

import de.fhdw.gaming.ipspiel21.searchtrees.domain.NextMoveGenerator;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.VierGewinntMove;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.factory.VierGewinntMoveFactory;

/**
 * generate the next Move.
 */
public class VierGewinntNextMoveGenerator
        implements NextMoveGenerator<VierGewinntPlayer, VierGewinntState, VierGewinntMove> {

    /**
     * The Move Factory.
     */
    private final VierGewinntMoveFactory moveFactory;

    /**
     * Constructor which uses the given MoveFactory.
     * 
     * @param moveFactory
     */
    VierGewinntNextMoveGenerator(final VierGewinntMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Collection<VierGewinntMove> getAllNextMoves(final VierGewinntState state,
            final VierGewinntPlayer player) {
        return state.getBoard().getAllPlayableFields().stream()
                .map(field -> this.moveFactory.createMove(field.getPosition())).collect(Collectors.toList());
    }

}
