/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.viergewinnt.strategies.group2.strategy;

import de.fhdw.gaming.ipspiel21.searchtrees.domain.Evaluation;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntDirection;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntField;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntFieldState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VierGewinntEvaluation
implements Evaluation<VierGewinntPlayer, VierGewinntState> {
    private static final Map<Integer, Double> EVALUATION_MAP = Map.of(1, 1.0, 2, 50.0, 3, 300.0, 4, 1.0E7);

    public Double evaluate(VierGewinntPlayer player, VierGewinntState state) {
        return this.evaluatePlayer(player, state);
    }

    private Double evaluatePlayer(VierGewinntPlayer player, VierGewinntState state) {
        return state.getBoard().getFieldsBeing(player.getPlayerMark()).values().stream().map(field -> this.getRows((VierGewinntField)field, 4)).map(rows -> rows.stream().mapToDouble(row -> this.evaluateRow((List<VierGewinntFieldState>)row, player.getPlayerMark(), this.getOtherPlayer(player, state).getPlayerMark())).sum()).reduce(0.0, Double::sum);
    }

    private VierGewinntPlayer getOtherPlayer(VierGewinntPlayer player, VierGewinntState state) {
        if (player.isUsingYellow()) {
            return state.getRedPlayer();
        }
        return state.getYellowPlayer();
    }

    private Double evaluateRow(List<VierGewinntFieldState> row, VierGewinntFieldState playerState, VierGewinntFieldState otherPlayerState) {
        if (row.contains(otherPlayerState) || row.size() < 4) {
            return 0.0;
        }
        return EVALUATION_MAP.get(this.numberOfFieldState(row, playerState));
    }

    private Integer numberOfFieldState(List<VierGewinntFieldState> row, VierGewinntFieldState state) {
        return (int)row.stream().filter(x -> x.equals((Object)state)).count();
    }

    private List<List<VierGewinntFieldState>> getRows(VierGewinntField field, Integer radius) {
        ArrayList<List<VierGewinntFieldState>> rows = new ArrayList<List<VierGewinntFieldState>>();
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.NORTHWEST));
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.SOUTHEAST));
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.NORTHEAST));
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.SOUTHWEST));
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.NORTH));
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.SOUTH));
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.WEST));
        rows.add(this.getRowsHelper(field, radius, VierGewinntDirection.EAST));
        return rows;
    }

    private List<VierGewinntFieldState> getRowsHelper(VierGewinntField field, Integer radius, VierGewinntDirection direction) {
        ArrayList<VierGewinntFieldState> out = new ArrayList<VierGewinntFieldState>();
        out.add(field.getState());
        VierGewinntField currentField = field;
        for (int i = 0; i < radius - 1; ++i) {
            if (!currentField.hasNeighbour(direction)) {
                return out;
            }
            currentField = currentField.getNeighbour(direction);
            out.add(currentField.getState());
        }
        return out;
    }
}

