/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-demo.
 *
 * Ipspiel21-demo is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-demo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-demo. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.demo.domain;

import de.fhdw.gaming.core.domain.State;

/**
 * Represents the state of a Demo game.
 */
public interface DemoState extends State<DemoPlayer, DemoState> {

    /**
     * Returns the first player.
     */
    DemoPlayer getFirstPlayer();

    /**
     * Returns the second player.
     */
    DemoPlayer getSecondPlayer();

    /**
     * Records the answer of a player.
     *
     * @param player The player.
     * @param answer The player's answer ({@code true} means "yes", {@code false} means "no").
     */
    void setAnswer(DemoPlayer player, boolean answer);
}
