package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements the {@link DilemmaStrategy} (evolving) with a mistrust tit-for-tat strategy. Confesses in the first round
 * and then copies the last move of the enemy player.
 */
class DilemmaMistrustStrategy implements DilemmaStrategy {

    /**
     * Factory for creating Dilemma moves.
     */
    private final DilemmaMoveFactory moveFactory;

    /**
     * Creates a {@link DilemmaTitForTatStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    public DilemmaMistrustStrategy(final DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<DilemmaMove> computeNextMove(final int gameId, final DilemmaPlayer player, final DilemmaState state)
            throws GameException, InterruptedException {

        if (player.getGameHistoryCollection().numberOfPlayedGames() == 0) {
            return Optional.of(moveFactory.createNoMove());
        } else {
            return Optional
                    .of((DilemmaMove) player.getGameHistoryCollection().getSpecificGameHistory(0).getOpponentMove(0));
        }
    }

    @Override
    public String toString() {
        return DilemmaMistrustStrategy.class.getSimpleName();
    }
}
