/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-freizeit.
 *
 * Ipspiel21-freizeit is free software: you can redistribute it and/or modify it under the terms of the GNU
 * General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-freizeit is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-freizeit. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain.factory;

import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitStrategy;
import de.fhdw.gaming.ipspiel21.freizeit.moves.factory.FreizeitMoveFactory;

/**
 * Represents a factory creating Freizeit strategies.
 */
@FunctionalInterface
public interface FreizeitStrategyFactory {

    /**
     * Creates a Freizeit strategy.
     *
     * @param moveFactory The {@link FreizeitMoveFactory} to use.
     * @return The Freizeit strategy.
     */
    @SuppressWarnings("exports")
    FreizeitStrategy create(FreizeitMoveFactory moveFactory);
}
