package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.factory.DilemmaStrategyFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;
/**
 * Implements {@link DilemmaStrategyFactory} by creating a {@link DilemmaTitForTatStrategy}.
 */
public final class DilemmaTitForTatStrategyFactory implements DilemmaStrategyFactory {

    @Override
    public DilemmaStrategy create(final DilemmaMoveFactory moveFactory) {
        return new DilemmaTitForTatStrategy(moveFactory);
    }

}
