package de.fhdw.gaming.ipspiel21.evolution;

import java.util.Optional;

import de.fhdw.gaming.core.domain.Move;

/**
 * A collection of HistoryEntry objects. Represents the memory for one game of a player.
 */
public interface GameHistory {

    /**
     * returns the played move at the provided index.
     *
     * @param index 0 = current, 1 = last, 2 = second last, etc.
     */
    Move<?, ?> getMove(Integer index);

    /**
     * returns the played move of the opponent player at the provided index.
     *
     * @param index 0 = current, 1 = last, 2 = second last, etc.
     */
    Move<?, ?> getOpponentMove(Integer index);

    /**
     * returns the outcome.
     */
    Optional<Double> getOutcome();

    /**
     * sets the outcome.
     *
     * @param outcome
     * @param opponent True if the outcome is for the opponent player
     */
    void setOutcome(boolean opponent, Optional<Double> outcome);

    /**
     * returns the outcome of the opponent player.
     */
    Optional<Double> getOpponentOutcome();

    /**
     * Adds a move to the game history.
     *
     * @param opponent True if the move is from the opponent player
     * @param move
     */
    void addMove(boolean opponent, Move<?, ?> move);

    /**
     * returns the number of played moves.
     */
    Integer numberOfPlayedMoves();

    /**
     * returns the game id for which the history is.
     */
    Integer getGameId();

}
