/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahl.
 *
 * Ipspiel21-kopfzahl is free software: you can redistribute it 
 * and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahl is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahl. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder which allows to create a Kopfzahl player.
 */
public interface KopfzahlPlayerBuilder {

    /**
     * Changes the name of the player.
     * <p>
     * There is no default.
     *
     * @param newName The name of the player.
     * @return {@code this}
     */
    KopfzahlPlayerBuilder changeName(String newName);

    /**
     * Changes the possible outcomes of the player.
     * <p>
     * There is no default.
     *
     * @param outcomeforplayer The possible outcomes of the player. The key for the 
     * first-level map is the answer of thefirst player, the key for the second-level map 
     * is the answer of the second player.
     */
    KopfzahlPlayerBuilder changePossibleOutcomes(Map<SaidMove, Map<SaidMove, Double>> outcomeforplayer);

    /**
     * Builds the player.
     *
     * @param state The Kopfzahl game state.
     * @return The Kopfzahl player.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    KopfzahlPlayer build(KopfzahlState state) throws GameException;
}
