/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntStrategy;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.VierGewinntMove;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.factory.VierGewinntMoveFactory;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.event.VierGewinntBoardEventVisitor;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.event.VierGewinntMakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl.VierGewinntGuiObserverImpl;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class VierGewinntInteractiveStrategy
implements VierGewinntStrategy {
    private final VierGewinntMoveFactory moveFactory;

    VierGewinntInteractiveStrategy(VierGewinntMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<VierGewinntMove> computeNextMove(int gameId, VierGewinntPlayer player, VierGewinntState state) throws GameException {
        Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiObserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }
        final AtomicReference move = new AtomicReference();
        provider.get().waitForEvent(player, state).accept(new VierGewinntBoardEventVisitor(){

            @Override
            public void handleMakeMove(VierGewinntMakeMoveBoardEvent event) {
                move.setPlain(VierGewinntInteractiveStrategy.this.moveFactory.createMove(event.getFieldPosition()));
            }
        });
        return Optional.ofNullable((VierGewinntMove)move.getPlain());
    }

    public String toString() {
        return VierGewinntInteractiveStrategy.class.getSimpleName();
    }

    public boolean isInteractive() {
        return true;
    }

    public void abortRequested(int gameId) {
        Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiObserverImpl.getEventProvider(gameId);
        if (!provider.isEmpty()) {
            provider.get().cancelWaiting();
        }
    }
}

