package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements {@link DilemmaStrategy} (evolving) with the spite strategy. Stays silent until the enemy player confesses
 * the first time. Then always confesses.
 */
final class DilemmaSpiteStrategy implements DilemmaStrategy {

    /**
     * Factory for creating Dilemma moves.
     */
    private final DilemmaMoveFactory moveFactory;

    /**
     * Creates a {@link DilemmaTitForTatStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    public DilemmaSpiteStrategy(final DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<DilemmaMove> computeNextMove(final int gameId, final DilemmaPlayer player, final DilemmaState state)
            throws GameException, InterruptedException {

        // Player should stay silent in the first round
        if (player.getGameHistoryCollection().numberOfPlayedGames() == 0) {
            return Optional.of(moveFactory.createYesMove());
        }

        if (player.getGameHistoryCollection().getSpecificGameHistory(0).getOpponentMove(0)
                .equals(moveFactory.createNoMove())
                || player.getGameHistoryCollection().getSpecificGameHistory(0).getMove(0)
                        .equals(moveFactory.createNoMove())) {
            return Optional.of(moveFactory.createNoMove());
        } else {
            return Optional.of(moveFactory.createYesMove());
        }
    }

    @Override
    public String toString() {
        return DilemmaSpiteStrategy.class.getSimpleName();
    }
}
