/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahl.
 *
 * Ipspiel21-kopfzahl is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahl is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahl. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlPlayer;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlState;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.KopfzahlMove;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.factory.KopfzahlMoveFactory;

/**
 * Implements {@link KopfzahlStrategy} by always saying "no".
 */
public final class KopfzahlSayKopfStrategy implements KopfzahlStrategy {

    /**
     * The factory for creating Kopfzahl moves.
     */
    private final KopfzahlMoveFactory moveFactory;

    /**
     * Creates an {@link KopfzahlSayNoStrategy}.
     *
     * @param moveFactory The factory for creating Kopfzahl moves.
     */
    KopfzahlSayKopfStrategy(final KopfzahlMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
public Optional<KopfzahlMove> computeNextMove(final int gameId, 
final KopfzahlPlayer player, final KopfzahlState state) {
        return Optional.of(this.moveFactory.createKopfMove());
    }

    @Override
    public String toString() {
        return KopfzahlSayKopfStrategy.class.getSimpleName();
    }
}
