package de.fhdw.gaming.ipspiel21.searchtrees.domain;

import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 *
 * Represent the evaluation function.
 *
 * @param <P>
 * @param <S>
 */
public interface Evaluation<P extends Player, S extends State<P, S>> {
    /**
     * Evaluates the game state.
     *
     * @param state  The state of the game.
     * @param player The current player.
     * @return evaluated score.
     */
    Double evaluate(P player, S state);

}
