/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaCustomized.impl;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGame;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGameBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.evolution.MemoryObserver;

final class DilemmaCustomizedGameBuilderWrapper
implements DilemmaGameBuilder {
    private final DilemmaGameBuilder wrapped;

    DilemmaCustomizedGameBuilderWrapper(DilemmaGameBuilder wrapped) {
        this.wrapped = wrapped;
    }

    public GameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.wrapped.changeMaximumComputationTimePerMove(newMaxComputationTimePerMove);
        return this;
    }

    public DilemmaPlayerBuilder createPlayerBuilder() {
        return this.wrapped.createPlayerBuilder();
    }

    public DilemmaGameBuilder addPlayerBuilder(DilemmaPlayerBuilder playerBuilder, DilemmaStrategy strategy) throws GameException {
        this.wrapped.addPlayerBuilder(playerBuilder, strategy);
        return this;
    }

    public DilemmaGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.wrapped.changeObserverFactoryProvider(newObserverFactoryProvider);
        return this;
    }

    public DilemmaGame build(int id) throws GameException, InterruptedException {
        DilemmaGame game = this.wrapped.build(id);
        game.addObserver((Observer)MemoryObserver.INSTANCE);
        return game;
    }
}

