/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-Dilemma.
 *
 * Ipspiel21-Dil is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-Dil is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-Dilemma. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl;

import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;

/**
 * Represents a move allowed by the rules of the game. The purpose of this class is solely to be able to check whether a
 * {@link DilemmaMove} implementation is allowed by the rules of the game. As this class is not public, custom
 * strategies are unable to create {@link DilemmaMove} objects that inherit from this class, so custom moves can be
 * distinguished from possible moves easily.
 */
public abstract class AbstractDilemmaMove implements DilemmaMove {

    /**
     * The name of subclasses are stored in this abstract Move.
     */
    private final String name;

    /**
     * Protected constructor.
     * 
     * @param name is the name of the current Move.
     */
    protected AbstractDilemmaMove(final String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final AbstractDilemmaMove other = (AbstractDilemmaMove) obj;
        if (name == null) {
            if (other.name != null) {
                return false;
            }
        } else if (!name.equals(other.name)) {
            return false;
        }
        return true;
    }
}
