package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements {@link DilemmaStrategy} with the pavlov strategy. Kooperiert in der ersten Runde und verrät, falls der
 * vorherige Zug des Mitspielers anders als der eigene war. Kooperiert, wenn in der Vorrunde beide Spieler kooperierten
 * oder beide verrieten.
 */
public final class DilemmaPavlovStrategy implements DilemmaStrategy {

    /**
     * The factory for creating Dilemma moves.
     */
    private final DilemmaMoveFactory moveFactory;

    /**
     * Creates an {@link DilemmaPavlovStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    public DilemmaPavlovStrategy(final DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<DilemmaMove> computeNextMove(final int gameId, final DilemmaPlayer player,
            final DilemmaState state) throws GameException, InterruptedException {
        System.out.println(player.getGameHistoryCollection().numberOfPlayedGames());
        if (player.getGameHistoryCollection().numberOfPlayedGames() == 0) {
            return Optional.of(this.moveFactory.createYesMove());
        } else if (player.getGameHistoryCollection().numberOfPlayedGames() > 0) {
            if (player.getGameHistoryCollection().getSpecificGameHistory(0).getMove(0)
                    .equals(player.getGameHistoryCollection().getSpecificGameHistory(0).getOpponentMove(0))) {
                return Optional.of(this.moveFactory.createYesMove());
            } else {
                return Optional.of(this.moveFactory.createNoMove());
            }
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return DilemmaPavlovStrategy.class.getSimpleName();
    }
}
