package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.factory.DilemmaStrategyFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements {@link DilemmaStrategyFactory} by creating a {@link DilemmaProberStrategy}.
 */
public class DilemmaProberStrategyFactory implements DilemmaStrategyFactory {

    @Override
    public final DilemmaStrategy create(final DilemmaMoveFactory moveFactory) {
        return new DilemmaProberStrategy(moveFactory);
    }

}
