/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGame;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGameBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl.DilemmaGameImpl;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl.DilemmaPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl.DilemmaStateImpl;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.AbstractDilemmaMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

public final class DilemmaGameBuilderImpl
implements DilemmaGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<DilemmaPlayerBuilder> firstPlayer = Optional.empty();
    private Optional<DilemmaStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<DilemmaPlayerBuilder> secondPlayer = Optional.empty();
    private Optional<DilemmaStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    @Override
    public DilemmaPlayerBuilder createPlayerBuilder() {
        return new DilemmaPlayerBuilderImpl();
    }

    @Override
    public DilemmaGameBuilder addPlayerBuilder(DilemmaPlayerBuilder playerBuilder, DilemmaStrategy strategy) throws GameException {
        Objects.requireNonNull(playerBuilder);
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(playerBuilder);
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(playerBuilder);
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public DilemmaGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public DilemmaGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public DilemmaGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A dilemma game needs two players.");
        }
        DilemmaStateImpl initialState = new DilemmaStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, DilemmaStrategy> strategies = new LinkedHashMap<String, DilemmaStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new DilemmaGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractDilemmaMove.class::isInstance, this.observerFactoryProvider);
    }
}

