/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahl.
 *
 * Ipspiel21-kopfzahl is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahl is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahl. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * A builder which allows to create a Kopfzahl game.
 */
public interface KopfzahlGameBuilder extends GameBuilder {

    /**
     * Creates an {@link KopfzahlPlayerBuilder} which allows to create and add a player to the game together with her
     * strategy.
     */
    KopfzahlPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player builder and the corresponding strategy.
     *
     * @param playerBuilder The builder player used for creating the player.
     * @param strategy      The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    KopfzahlGameBuilder addPlayerBuilder(KopfzahlPlayerBuilder playerBuilder, 
    KopfzahlStrategy strategy) throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */
    KopfzahlGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override
    KopfzahlGame build(int id) throws GameException, InterruptedException;
}
