/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahl.
 *
 * Ipspiel21-kopfzahl is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahl is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahl. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain.factory;

import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.factory.KopfzahlMoveFactory;

/**
 * Represents a factory creating Kopfzahl strategies.
 */
@FunctionalInterface
public interface KopfzahlStrategyFactory {

    /**
     * Creates a Kopfzahl strategy.
     *
     * @param moveFactory The {@link KopfzahlMoveFactory} to use.
     * @return The Kopfzahl strategy.
     */
    KopfzahlStrategy create(KopfzahlMoveFactory moveFactory);
}
