package de.fhdw.gaming.ipspiel21.searchtrees.domain;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 * Represent the search tree algorithms.
 *
 * @param <P>
 * @param <S>
 * @param <M>
 */
public interface SearchTreeAlgorithms<P extends Player, S extends State<P, S>, M extends Move<P, S>> {

    /**
     * generates the best move.
     *
     * @param depth         The chosen depth of search tree.
     * @param currentPlayer The player who has to do the next move.
     * @param generator     The generator which creates next moves.
     * @param state         The current state.
     * @param evaluator     The abstract evaluator.
     * @return the best move of current player.
     * @throws GameException
     */
    Optional<M> getBestMove(int depth, P currentPlayer, NextMoveGenerator<P, S, M> generator, S state,
            Evaluation<P, S> evaluator) throws GameException;
}
