package de.fhdw.ipspiel21.viergewinnt.strategies.group1.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.SearchTreeAlgorithms;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.impl.MinimaxImpl;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntFieldState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntStrategy;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.VierGewinntMove;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.factory.VierGewinntMoveFactory;

/**
 * Strategie which uses the MinMax Algorithm.
 */
public class VierGewinntStrategyMinMax implements VierGewinntStrategy {

    /**
     * The MoveFactory.
     */
    private final VierGewinntMoveFactory moveFactory;

    /**
     * Constructor which uses the given moveFactory.
     *
     * @param moveFactory
     */
    VierGewinntStrategyMinMax(final VierGewinntMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<VierGewinntMove> computeNextMove(final int gameId, final VierGewinntPlayer player,
            final VierGewinntState state) throws GameException, InterruptedException {
        if (!state.getBoard().getFieldsBeing(VierGewinntFieldState.EMPTY).isEmpty()) {
            final SearchTreeAlgorithms<VierGewinntPlayer, VierGewinntState, VierGewinntMove> algorithm =
                    new MinimaxImpl<>();
            return algorithm.getBestMove(5, player, new VierGewinntNextMoveGenerator(this.moveFactory), state,
                    new VierGewinntEvaluation());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public String toString() {
        return "VierGewinnt Group1 MinMax";
    }

}
