/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event.VierGewinntBoardEventVisitor;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.event.VierGewinntMakeMoveBoardEvent;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl.VierGewinntGuiOberserverImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class VierGewinntInteractiveStrategy
implements VGStrategy {
    private final VGMoveFactory moveFactory;

    VierGewinntInteractiveStrategy(VGMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    public Optional<VGMove> computeNextMove(int gameId, final VGPlayer player, VGState state) throws GameException {
        Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiOberserverImpl.getEventProvider(gameId);
        if (provider.isEmpty()) {
            return Optional.empty();
        }
        final AtomicReference move = new AtomicReference();
        provider.get().waitForEvent(player, state).accept(new VierGewinntBoardEventVisitor(){

            @Override
            public void handleMakeMove(VierGewinntMakeMoveBoardEvent event) {
                move.setPlain(VierGewinntInteractiveStrategy.this.moveFactory.createTokenMove(player.isUsingRedChips(), event.getFieldPosition()));
            }
        });
        return Optional.ofNullable((VGMove)move.getPlain());
    }

    public String toString() {
        return VierGewinntInteractiveStrategy.class.getSimpleName();
    }

    public boolean isInteractive() {
        return true;
    }

    public void abortRequested(int gameId) {
        Optional<VierGewinntBoardEventProvider> provider = VierGewinntGuiOberserverImpl.getEventProvider(gameId);
        if (!provider.isEmpty()) {
            provider.get().cancelWaiting();
        }
    }
}

