/*
 * Copyright © 2020 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of othello-core.
 *
 * Othello-core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Othello-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with othello-core. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.domain;

import de.fhdw.gaming.core.domain.GameException;

/**
 * Represents a single field on a {@link VGBoard board}.
 * <p>
 * A field has a {@link VGPosition position}. This position is fixed and does not change.
 * <p>
 * The state of a field cannot be changed directly. Instead, a conforming move has to be submitted.
 */
public interface VGField {

    /**
     * Returns the board this field belongs to.
     */
    VGBoard getBoard();

    /**
     * Returns the position of this field.
     */
    VGPosition getPosition();

    /**
     * Returns the current state of this field.
     */
    VGFieldState getState();
    
    /**
     * Sets the current state of this field.
     * @param newState
     */
    void setState(VGFieldState newState) throws IllegalArgumentException;

    /**
     * Places a token on this field. Requires this field to be active. Computes and changes the state of neighbour
     * fields according to the rules of the game.
     *
     * @param redChip {@code true} if a black token is placed, and {@code false} if a white token is placed.
     * @throws GameException if placing a token of the given colour is not allowed according to the rules of the game.
     */
    void placeToken(boolean redChip) throws GameException;
}
